import re
class EpisodeMemory:
    def __init__(self):
        self.history = []

    def reset(self) -> None:
        """
        Resets the episode history.
        """
        self.history = []

    def add(self, label: str, value: str) -> None:
        """
        Adds a new timestep entry to the episode history.
        """
        assert label in ['action', 'observation', 'analysis']
        self.history += [{
            'label': label,
            'value': value
        }]

    def __str__(self) -> str:
        """
        Returns a string representation of the episode history.
        """
        s = ''
        for entry in self.history:
            s += f'{entry["label"]}: {entry["value"]}\n'
        return s
